/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.block;

import club.someoneice.jellyfishingdelight.block.GrillTile;
import club.someoneice.jellyfishingdelight.core.TileList;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public final class Grill
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public Grill() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(0.2f).m_60999_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof GrillTile)) {
            return InteractionResult.CONSUME;
        }
        GrillTile tile = (GrillTile)blockEntity;
        ItemStack item = pPlayer.m_21120_(pHand);
        if (!GrillTile.canPut(pLevel, item)) {
            return InteractionResult.FAIL;
        }
        return tile.putItem(item) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GrillTile) {
            PickaxeItem pickaxeItem;
            GrillTile tile = (GrillTile)blockEntity;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int i = 0; i < tile.container.getSlots(); ++i) {
                drops.add(tile.container.extractItem(i, 1, false).m_278832_());
            }
            Item item = player.m_21205_().m_41720_();
            if (item instanceof PickaxeItem && (pickaxeItem = (PickaxeItem)item).m_43314_().m_6604_() >= 1) {
                drops.add(this.m_5456_().m_7968_());
            }
            drops.stream().map(it -> new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, it)).forEach(arg_0 -> ((Level)level).m_7967_(arg_0));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GrillTile(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Grill.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)TileList.GRILL.get()), GrillTile::cookingTick);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }
}

